# MIT License
# Copyright (c) 2025 aiquniq
# See LICENSE file in the project root for full license text.

import os, re
import requests
from typing import Optional

def safe_filename(stem: str, suffix: str) -> str:
    stem = re.sub(r"[^a-zA-Z0-9\-_]+", "-", stem).strip("-")
    return f"{stem}{suffix}"

def stream_download(url: str, dest_dir: str, base_name: str, session: requests.Session, timeout=30, require_pdf: bool=False) -> Optional[str]:
    try:
        with session.get(url, stream=True, timeout=timeout) as r:
            r.raise_for_status()
            ct = (r.headers.get("Content-Type") or "").lower()
            if require_pdf and "pdf" not in ct:
                return None
            ext = ".pdf" if ("pdf" in ct) else (".html" if ("html" in ct or "text/" in ct) else "")
            fn = safe_filename(base_name, ext or "")
            path = os.path.join(dest_dir, fn)
            with open(path, "wb") as f:
                for chunk in r.iter_content(chunk_size=1024 * 64):
                    if chunk:
                        f.write(chunk)
            return path
    except Exception:
        return None
