# MIT License
# Copyright (c) 2025 aiquniq
# See LICENSE file in the project root for full license text.

import re
from datetime import datetime

def slugify(value: str) -> str:
    value = value.strip().lower()
    value = re.sub(r"[^a-z0-9\-_]+", "-", value)
    value = re.sub(r"-{2,}", "-", value).strip("-")
    return value or "untitled"

def timestamp() -> str:
    return datetime.now().strftime("%Y%m%d_%H%M%S")
